
// MARK: - popover presets menu

function presetsGroup(styles)
{
	styles = styles || "useMarkup";
	
	return {
		nsClass: "GXDrawView",
		gxLayout: [
			"H:[self]-8-|",
			"V:[self]-8-|",
			"H:|-4-[presetsLabel(55)]-8-[presets(202)]-4-|&alignBaseline",
			"V:|-4-[presets(25)]-4-|"
		],
		gxChildViews:
		{
			presets:
			{
				"+": "PopupMenuView." + styles,
				gxFaceModel: {
					nsClass: "H4PresetsFaceModel",
				},
				gxViewName: "presets",
				axTitle: "Presets",
				axHelp: "Create or use pre-sets for this block",
			},
			presetsLabel: labelView("Presets:", "right")
		}
	};
}


// ---------------------------------------------

markup.push({


// MARK: - presets window

PresetsWindow:
{
	nsClass: "GXWindow",
	gxWindowTitle: "Presets",
	gxWindowMaxSize: "320, 2000",
	gxWindowMinSize: "320, 230",
	gxInitialWindowSize: "320, 250",
	gxInitialWindowPosition: "0.3, 0.3",
	gxSavedWindowStateKey: "presetsWindow",
	gxBackColor: "BackColor2",
	gxContentView: "PresetsWindowContentView"
},

	
// MARK: content view

PresetsWindowContentView:
{
	nsClass: "GXDrawView",
	gxLayout:
	[
		"H:[self(320)]",
		
		"V:[titleBarView]-0-[titleGroup(38)]-0-[presetsScroller]-0-[bottomBar(36)]-0-|",
		
		"H:|-0-[titleGroup]-0-|",
		"H:|-0-[presetsScroller]-0-|",
		"H:|-0-[presetsList]-0-|",
	],
	gxChildViews:
    {
		titleBarView:
		{
			"+": "TitleBarView",
			gxChildViews:
			{
				windowTitle: {
					"+": "WindowTitle",
					gxDefaultValue: "Presets",
				},
			},
		},
		titleGroup:
		{
			"+": "GroupView",
			gxLayout:
			[
				"H:|-15-[groupTitle]-0-|",
				"V:|-10-[groupTitle]",
			],
			gxChildViews:
			{
				groupTitle: {
					"+": "LabelView.useMarkup.left",
					gxValueKey: "displayName",
				},
			}
		},
		presetsScroller:
        {
			nsClass: "GXScrollView",
			gxBackColor: "SidebarBackColor2",
			gxVScrollbar: "ScrollBarView",	// vertical scroller only
			gxDocumentView:
            {
				gxViewName: "presetsList",
				nsClass: "GXListView",
				gxItemHeight: 31,
				gxInterItemHeight: 1,
				gxTopHeight: 6,
				gxBottomHeight: 6,
				gxListItemView: "PresetItemView",
				gxValueKey: "presetsListValue",
				gxDeleteKey: "deleteBtn",
				axTitle: "Presets List",
				axHelp: "Edit preset names or delete them from this list. Presets are used on individual Blocks within Sessions",
			}
		},
		bottomBar:
		{
			nsClass: "GXDrawView",
			gxBackPainter: "BottomBarBack",
			gxLayerZPosition: 1,
			gxLayout: [ "H:|-0-[self]-0-|",
					  	"H:[deleteBtn(24)]-14-|",
						"H:[self]-(<=0)-[deleteBtn]&alignCenterY" ],  // center vertically
			gxChildViews:
			{
				deleteBtn:
				{
					"+": "MinusButton",
					gxTitle: "<minusButton/>",
					gxValueKey: "deleteBtn",
					gxDisableOnNil: true,
					axDescription: "Delete selected sessions",
				}
			}
		}
	}
},

	
// MARK: preset item

PresetItemView:
{
	nsClass: "GXListItemView",
	gxIntrinsicWidth: 300,
	gxBackPainter: {
		"+": "ListItemBack.altRow",
		gxFillColor: "",	// skip fill until selected
		gxEdgeInsets: "7, 0, 2, 0",
	},
	gxSelectable: 2, // multiselect
	gxLateLayout:
	[
		"V:|-(-999)-[self(31)]",	// vertical position set by parent

		"H:|-10-[presetIcon]-2-[presetName]-8-|",
		"V:|-3-[presetName(24)]",
		"V:|-3-[presetIcon(24)]",
	],
	gxChildViews:
	{
		presetIcon:
		{
			"+": "LabelView.foreColor1.left.clip.useMarkup",
			gxValueKey: "iconMarkup",
		},
		presetName:
		{
			"+": "BaseTextField",
			gxValueKey: "name",
			gxEditingKeyPath: "editing",
			gxTextPainter: { "+": "ControlFore", gxHAlign: 0, gxFontSize: 13 },
			gxEdgeInsets: "2, 4, 2, 3",
			gxPencilForePainter: "PencilForePainter",
			gxPencilBackPainter: "PencilBackPainter",
			gxFocusRingPainter: "ControlBack",
			gxIntrinsicWidth: -1,
		}
	}
},

	
})
